/*
Opleiding	: Basisvaardigheden SQL Query's schrijven van SQLTeam.NL
Module		: Data in tabellen bewerken, verwijderen en verwijderen en leegmaken van tabellen
Onderwerpen	: INSERT / UPDATE / DELETE / TRUNCATE TABLE / DROP TABLE
			  Verplicht gebruik van transacties en WHERE functie

-- Voordat je begint
DROP TABLE IF EXISTS #TijdelijkeTabel
DROP TABLE IF EXISTS #_bck_TijdelijkeTabel
*/

/* Maak een tijdelijke tabel aan (met gebruik van #) */
CREATE TABLE #TijdelijkeTabel (
	Klantnummer		int,			-- Integer
	Voornaam		varchar(50),	-- String met maximaal 50 tekens
	Geboortedatum	datetime,		-- Datumveld
	IsGetrouwd		bit				-- Bitveld (0=nee, 1=ja)
)

/* Toevoegen van records, geen transacties / WHERE functie */
-- Via VALUES functie records toevoegen
INSERT INTO #TijdelijkeTabel (
	Klantnummer,
	Voornaam,
	Geboortedatum,
	IsGetrouwd
)
VALUES 
	(1,'Pietje','1960-01-01',1),
	(2,'Marietje','1970-01-01',1),
	(3,'Peter','1980-01-01',1),
	(4,'Elsa','1990-01-01',0),
	(5,'Harry','2000-01-01',1),
	(6,'Barry','2010-01-01',0)

-- Resultaat bekijken
SELECT 
*
FROM #TijdelijkeTabel

/*
	Verwijderen van hele (!) records
	TRANSACTIE en WHERE gebruiken!!!
*/
-- Controleer eerst aantal en welke records zullen worden geraakt
SELECT
*
FROM #TijdelijkeTabel t
WHERE t.Klantnummer = 3

BEGIN TRAN -- Start een transactie

DELETE t	-- Alias voor #TijdelijkeTabel
FROM #TijdelijkeTabel t
WHERE t.Klantnummer = 3

-- Controleer in het tabblad 'messages' aantal geraakte records

-- Controleer of het record nog bestaat
SELECT
*
FROM #TijdelijkeTabel t
WHERE t.Klantnummer = 3

-- Transactie goed? COMMIT! Anders direct ROLLBACK!
-- ROLLBACK TRAN	-- om de actie ongedaan te maken
-- COMMIT TRAN		-- om de actie te bevestigen

/*
	Bijwerken van records met UPDATE functie
	TRANSACTIE en WHERE gebruiken!!!
*/
SELECT
*
FROM #TijdelijkeTabel t
WHERE t.Voornaam = 'Elsa'

BEGIN TRAN -- Start een transactie

UPDATE t
SET Voornaam = 'Elza'
FROM #TijdelijkeTabel t
WHERE t.Voornaam = 'Elsa'

-- Controleer in het tabblad 'messages' aantal geraakte records

-- Controleer of het record is gewijzigd
SELECT
*
FROM #TijdelijkeTabel t
WHERE t.Voornaam = 'Elza' -- Let op: dus nieuwe spelling!

-- Transactie goed? COMMIT! Anders direct ROLLBACK!
-- ROLLBACK TRAN	-- om de actie ongedaan te maken
-- COMMIT TRAN		-- om de actie te bevestigen

/* Kopier de tabel #TijdelijkeTabel naar de tabel #_Bck_TijdelijkeTabel */
SELECT
*
INTO #_bck_TijdelijkeTabel
FROM #TijdelijkeTabel
-- WHERE Klantnummer = 1 -- filteren is dus toegestaan!

/* Leegmaken van de backup tabel */
TRUNCATE TABLE #_bck_TijdelijkeTabel

-- Tabel is ook daadwerkelijk leeg
SELECT
*
FROM #_bck_TijdelijkeTabel bt

/* Data toevoegen van records via SELECT */
INSERT INTO #_bck_TijdelijkeTabel (
	Klantnummer,
	Voornaam,
	Geboortedatum,
	IsGetrouwd
)
SELECT
	t.Klantnummer,
	t.Voornaam,
	t.Geboortedatum,
	t.IsGetrouwd
FROM #TijdelijkeTabel t
WHERE t.Klantnummer <= 3

/* Tabel verwijderen (kan niet ongedaan worden gemaakt!) */
DROP TABLE #_bck_TijdelijkeTabel;
DROP TABLE #TijdelijkeTabel;
